/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpManager.Admin;

import ibm.nways.analysis.dpCommon.NotifyObject;
import ibm.nways.analysis.dpCommon.PollingObjectDefinition;
import ibm.nways.analysis.dpManager.Admin.BasicConfigPanel;
import ibm.nways.analysis.dpManager.Admin.DpAdminPanel;
import ibm.nways.analysis.dpManager.Admin.IdSelector;
import ibm.nways.jdm.eui.ColumnLayout;
import ibm.nways.jdm.eui.MessageBox;
import java.applet.Applet;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCAlignerLayout;
import jclass.bwt.JCButton;
import jclass.bwt.JCGridLayout;

public class DpePollDefs
extends BasicConfigPanel
implements ItemListener,
JCActionListener,
TextListener {
    private boolean pollingIntervalInitializing = false;
    private boolean unitsInitializing = false;
    private boolean reArmValueBoxInitializing = false;
    private boolean armValueBoxInitializing = false;
    private boolean expressionBoxInitializing = false;
    private DpAdminPanel adminPanel;
    private boolean ok = false;
    private String previous;
    private IdSelector pollingID;
    private JCButton newButton;
    private JCButton deleteButton;
    private TextArea expressionBox;
    private Choice dataType;
    private TextField units;
    private TextField pollingInterval;
    private Choice notifyVariable;
    private Choice armOperationBox;
    private TextField armValueBox;
    private Choice reArmOperationBox;
    private TextField reArmValueBox;
    private PollingObjectDefinition newPOD;
    private NotifyObject newNotifyObj;
    private static ResourceBundle adminRB = ResourceBundle.getBundle("ibm.nways.analysis.dpManager.Admin.AdminResources");
    private static final String NEW_BUTTON_LABEL = adminRB.getString("s_New");
    private static final String DELETE_BUTTON_LABEL = adminRB.getString("s_Delete");
    private static final String POLLING_ID_LABEL = adminRB.getString("s_PollID");
    private static final String EXPRESSION_LABEL = adminRB.getString("s_Exp");
    private static final String DATA_TYPE_LABEL = adminRB.getString("s_DType");
    private static final String UNIT_LABEL = adminRB.getString("s_Units");
    private static final String POLL_INTVL_LABEL = adminRB.getString("s_PollIntvl");
    private static final String NOTIFY_LABEL = adminRB.getString("s_Notify");
    private static final String ARM_OP_LABEL = adminRB.getString("s_ArmOp");
    private static final String ARM_VALUE_LABEL = adminRB.getString("s_ArmVal");
    private static final String REARM_OP_LABEL = adminRB.getString("s_ReArmOp");
    private static final String REARM_VALUE_LABEL = adminRB.getString("s_ReArmVal");

    public DpePollDefs(DpAdminPanel dpAdminPanel, Applet applet) {
        super(applet);
        this.adminPanel = dpAdminPanel;
        this.pollingID = new IdSelector(POLLING_ID_LABEL, true);
        this.add("North", this.pollingID);
        this.pollingID.addItemListener(this);
        this.pollingID.addActionListener(this);
        Panel panel = new Panel();
        panel.setLayout(new JCAlignerLayout(2, 20, 10));
        Label label = new Label(EXPRESSION_LABEL);
        this.expressionBox = new TextArea("", 4, 40, 1);
        this.expressionBox.setEditable(false);
        this.expressionBox.addTextListener(this);
        panel.add(label);
        panel.add(this.expressionBox);
        Panel panel2 = new Panel();
        panel2.setLayout(new ColumnLayout());
        panel2.add(panel);
        Panel panel3 = new Panel();
        panel3.setLayout(new JCAlignerLayout(4, 20, 10));
        Label label2 = new Label(DATA_TYPE_LABEL);
        this.dataType = new Choice();
        this.populateDataTypes();
        this.dataType.setEnabled(false);
        this.dataType.addItemListener(this);
        Label label3 = new Label(UNIT_LABEL);
        this.units = new TextField(20);
        this.units.setEditable(false);
        this.units.addTextListener(this);
        panel3.add(label2);
        panel3.add(this.dataType);
        panel3.add(label3);
        panel3.add(this.units);
        panel2.add(panel3);
        Panel panel4 = new Panel();
        panel4.setLayout(new JCAlignerLayout(4, 10, 10));
        Label label4 = new Label(POLL_INTVL_LABEL);
        this.pollingInterval = new TextField(6);
        this.pollingInterval.addTextListener(this);
        Label label5 = new Label(NOTIFY_LABEL);
        this.notifyVariable = new Choice();
        this.populateNotifyVariable();
        this.notifyVariable.addItemListener(this);
        Label label6 = new Label(ARM_OP_LABEL);
        this.armOperationBox = new Choice();
        this.armOperationBox.addItemListener(this);
        Label label7 = new Label(ARM_VALUE_LABEL);
        this.armValueBox = new TextField(6);
        this.armValueBox.addTextListener(this);
        Label label8 = new Label(REARM_OP_LABEL);
        this.reArmOperationBox = new Choice();
        this.reArmOperationBox.addItemListener(this);
        Label label9 = new Label(REARM_VALUE_LABEL);
        this.reArmValueBox = new TextField(6);
        this.reArmValueBox.addTextListener(this);
        panel4.add(label4);
        panel4.add(this.pollingInterval);
        panel4.add(label5);
        panel4.add(this.notifyVariable);
        panel4.add(label6);
        panel4.add(this.armOperationBox);
        panel4.add(label7);
        panel4.add(this.armValueBox);
        panel4.add(label8);
        panel4.add(this.reArmOperationBox);
        panel4.add(label9);
        panel4.add(this.reArmValueBox);
        Panel panel5 = new Panel();
        panel5.setLayout(new JCGridLayout(2, 1, 10, 10));
        panel5.add(panel2);
        panel5.add(panel4);
        Panel panel6 = new Panel(new FlowLayout(1));
        panel6.add(panel5);
        this.add("Center", panel6);
    }

    private void populateDataTypes() {
        this.dataType.removeAll();
        Vector vector = PollingObjectDefinition.getDataTypes();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.dataType.add((String)enumeration.nextElement());
        }
    }

    private void populateNotifyVariable() {
        this.notifyVariable.removeAll();
        Vector vector = NotifyObject.getNotifyTypes();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.notifyVariable.add((String)enumeration.nextElement());
        }
    }

    private void populateArmOp() {
        this.armOperationBox.removeAll();
        Vector vector = NotifyObject.getOps();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.armOperationBox.add((String)enumeration.nextElement());
        }
    }

    public void populateReArmOp() {
        this.reArmOperationBox.removeAll();
        Vector vector = NotifyObject.getOps();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.reArmOperationBox.add((String)enumeration.nextElement());
        }
    }

    protected void populate() {
        String string = null;
        if (this.pollingID.getSelectedItem() != null) {
            string = this.pollingID.getSelectedItem();
        }
        Vector vector = null;
        try {
            vector = this.adminPanel.getClientApplet().getPollingObjectDefinitionList();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        if (vector != null) {
            this.pollingID.removeAllIds();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.pollingID.addId((String)enumeration.nextElement());
            }
            this.populateArmOp();
            this.populateReArmOp();
        }
        if (this.pollingID.getItemCount() > 0) {
            if (string == null || string.length() == 0) {
                string = this.pollingID.getItem(0);
            }
            this.selectItem(string);
        }
    }

    protected void displayPODInfo(String string) {
        PollingObjectDefinition pollingObjectDefinition = null;
        try {
            pollingObjectDefinition = this.adminPanel.getClientApplet().getPollingDefinition(string);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        if (pollingObjectDefinition != null) {
            String string2 = PollingObjectDefinition.toString(pollingObjectDefinition.getDataType());
            this.dataType.setEnabled(false);
            this.dataType.select(string2);
            String string3 = pollingObjectDefinition.getUnits();
            this.unitsInitializing = true;
            this.units.setEditable(false);
            ((TextComponent)this.units).setText(string3);
            String string4 = pollingObjectDefinition.getExpression();
            this.expressionBoxInitializing = true;
            this.expressionBox.setEditable(false);
            this.expressionBox.setText(string4);
            NotifyObject notifyObject = pollingObjectDefinition.getNotifyObject();
            String string5 = String.valueOf(notifyObject.getPollingInterval());
            this.pollingIntervalInitializing = true;
            ((TextComponent)this.pollingInterval).setText(string5);
            String string6 = notifyObject.toString(notifyObject.getWhenToNotify());
            this.notifyVariable.select(string6);
            String string7 = notifyObject.getArmOp();
            this.armOperationBox.select(string7);
            String string8 = String.valueOf(notifyObject.getArmValue());
            this.armValueBoxInitializing = true;
            ((TextComponent)this.armValueBox).setText(string8);
            String string9 = notifyObject.getRearmOp();
            this.reArmOperationBox.select(string9);
            String string10 = String.valueOf(notifyObject.getRearmValue());
            this.reArmValueBoxInitializing = true;
            ((TextComponent)this.reArmValueBox).setText(string10);
            this.setDirty(false);
            this.ok = true;
            return;
        }
        this.unitsInitializing = true;
        ((TextComponent)this.units).setText("");
        this.pollingIntervalInitializing = true;
        ((TextComponent)this.pollingInterval).setText("");
        this.armValueBoxInitializing = true;
        ((TextComponent)this.armValueBox).setText("");
        this.reArmValueBoxInitializing = true;
        ((TextComponent)this.reArmValueBox).setText("");
        this.expressionBoxInitializing = true;
        this.expressionBox.setText("");
        this.setDirty(true);
    }

    public static boolean validPollingInterval(String string) {
        boolean bl = true;
        int n = 0;
        try {
            n = Integer.valueOf(string);
            if (n <= 0) {
                bl = false;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public static boolean validArmRearmValue(String string) {
        boolean bl = true;
        float f = 0.0f;
        try {
            f = Float.valueOf(string).floatValue();
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public static boolean validExpressionValue(String string) {
        boolean bl = false;
        if (string != null && string.length() > 0) {
            bl = true;
        }
        return bl;
    }

    public void textValueChanged(TextEvent textEvent) {
        if (this.ok) {
            if (textEvent.getSource() == this.pollingInterval) {
                if (this.pollingIntervalInitializing) {
                    this.pollingIntervalInitializing = false;
                    return;
                }
                String string = this.pollingInterval.getText();
                if (DpePollDefs.validPollingInterval(string)) {
                    this.setDirty(true);
                    return;
                }
                this.setDirty(false);
                return;
            }
            if (textEvent.getSource() == this.units) {
                if (this.unitsInitializing) {
                    this.unitsInitializing = false;
                    return;
                }
                this.setDirty(true);
                return;
            }
            if (textEvent.getSource() == this.reArmValueBox) {
                if (this.reArmValueBoxInitializing) {
                    this.reArmValueBoxInitializing = false;
                    return;
                }
                String string = this.reArmValueBox.getText();
                if (DpePollDefs.validArmRearmValue(string)) {
                    this.setDirty(true);
                    return;
                }
                this.setDirty(false);
                return;
            }
            if (textEvent.getSource() == this.armValueBox) {
                if (this.armValueBoxInitializing) {
                    this.armValueBoxInitializing = false;
                    return;
                }
                String string = this.armValueBox.getText();
                if (DpePollDefs.validArmRearmValue(string)) {
                    this.setDirty(true);
                    return;
                }
                this.setDirty(false);
                return;
            }
            if (textEvent.getSource() == this.expressionBox) {
                if (this.expressionBoxInitializing) {
                    this.expressionBoxInitializing = false;
                    return;
                }
                String string = this.expressionBox.getText();
                if (DpePollDefs.validExpressionValue(string)) {
                    this.setDirty(true);
                    return;
                }
                this.setDirty(false);
            }
        }
    }

    public void selectItem(String string) {
        this.pollingID.select(string);
        this.displayPODInfo(string);
    }

    public void actionPerformed(JCActionEvent jCActionEvent) {
        if (jCActionEvent.getSource() == this.pollingID && jCActionEvent.getActionCommand().equals(NEW_BUTTON_LABEL)) {
            boolean bl = false;
            Vector vector = null;
            try {
                vector = this.adminPanel.getClientApplet().getPollingObjectDefinitionList();
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
            String string = this.pollingID.getSelectedItem();
            if (vector != null) {
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    if (!string2.equals(string)) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                this.selectItem(string);
                return;
            }
            this.displayPODInfo(string);
            this.expressionBox.setEditable(true);
            this.units.setEditable(true);
            this.dataType.setEnabled(true);
            this.setDirty(true);
            return;
        }
        if (jCActionEvent.getSource() == this.pollingID && jCActionEvent.getActionCommand().equals(DELETE_BUTTON_LABEL)) {
            String string = null;
            try {
                string = this.adminPanel.getClientApplet().removePollingObjectDefinition(this.pollingID.getSelectedItem());
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
            if (string == null) {
                int n = this.pollingID.getSelectedIndex();
                this.pollingID.removeId(this.pollingID.getSelectedItem());
                if (n > 0 && this.pollingID.getItemCount() > n) {
                    this.pollingID.select(n);
                    return;
                }
                if (this.pollingID.getItemCount() > 0) {
                    this.pollingID.select(0);
                    this.displayPODInfo(this.pollingID.getSelectedItem());
                    return;
                }
                this.displayPODInfo("");
                return;
            }
            String string3 = String.valueOf(adminRB.getString("s_MsgPodDeleteFailure")) + string;
            new MessageBox(this.getParentFrame(), adminRB.getString("s_MsgDeleteFail"), string3, true);
            return;
        }
        super.actionPerformed(jCActionEvent);
    }

    protected void cancel() {
        if (this.previous != null) {
            this.selectItem(this.previous);
        } else {
            if (this.pollingID.getSelectedIndex() < 0) {
                this.pollingID.select(0);
            }
            this.displayPODInfo(this.pollingID.getSelectedItem());
        }
        this.setDirty(false);
    }

    protected void save() {
        if (this.isDirty()) {
            int n;
            String string = this.pollingID.getSelectedItem();
            try {
                n = Integer.valueOf(this.pollingInterval.getText());
            }
            catch (NumberFormatException numberFormatException) {
                n = 600;
            }
            int n2 = NotifyObject.toInt(this.notifyVariable.getSelectedItem());
            String string2 = this.armOperationBox.getSelectedItem();
            float f = Float.valueOf(this.armValueBox.getText()).floatValue();
            String string3 = this.reArmOperationBox.getSelectedItem();
            float f2 = Float.valueOf(this.reArmValueBox.getText()).floatValue();
            NotifyObject notifyObject = null;
            notifyObject = n2 == 4 ? new NotifyObject(string2, f, string3, f2, n) : new NotifyObject(n2, n);
            PollingObjectDefinition pollingObjectDefinition = null;
            try {
                pollingObjectDefinition = this.adminPanel.getClientApplet().getPollingDefinition(string);
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
            if (pollingObjectDefinition == null) {
                int n3 = PollingObjectDefinition.toInt(this.dataType.getSelectedItem());
                String string4 = this.expressionBox.getText();
                String string5 = this.units.getText();
                PollingObjectDefinition pollingObjectDefinition2 = new PollingObjectDefinition(string, n3, string4, string5, notifyObject);
                try {
                    this.adminPanel.getClientApplet().addPollingObjectDefinition(pollingObjectDefinition2);
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace();
                }
                this.pollingID.addId(string);
                this.pollingID.select(string);
            } else {
                try {
                    this.adminPanel.getClientApplet().modifyPollingObjectDefinition(string, notifyObject);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        this.setDirty(false);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.pollingID && itemEvent.getStateChange() == 1) {
            this.previous = (String)itemEvent.getItem();
            this.displayPODInfo((String)itemEvent.getItem());
            return;
        }
        if (itemEvent.getSource() == this.dataType || itemEvent.getSource() == this.notifyVariable || itemEvent.getSource() == this.armOperationBox || itemEvent.getSource() == this.reArmOperationBox) {
            this.setDirty(true);
        }
    }
}

